using System;
using System.Runtime.InteropServices;

namespace Epic.OnlineServices.Auth;

[StructLayout(LayoutKind.Sequential, Pack = 8)]
internal struct IOSCredentialsSystemAuthCredentialsOptionsInternal : IGettable<IOSCredentialsSystemAuthCredentialsOptions>, ISettable<IOSCredentialsSystemAuthCredentialsOptions>, IDisposable
{
	private int m_ApiVersion;

	private IntPtr m_PresentationContextProviding;

	private IntPtr m_CreateBackgroundSnapshotView;

	private IntPtr m_CreateBackgroundSnapshotViewContext;

	private static IOSCreateBackgroundSnapshotViewInternal s_CreateBackgroundSnapshotView;

	public IntPtr PresentationContextProviding
	{
		get
		{
			return m_PresentationContextProviding;
		}
		set
		{
			m_PresentationContextProviding = value;
		}
	}

	public static IOSCreateBackgroundSnapshotViewInternal CreateBackgroundSnapshotView
	{
		get
		{
			if (s_CreateBackgroundSnapshotView == null)
			{
				s_CreateBackgroundSnapshotView = AuthInterface.IOSCreateBackgroundSnapshotViewInternalImplementation;
			}
			return s_CreateBackgroundSnapshotView;
		}
	}

	public IntPtr CreateBackgroundSnapshotViewContext
	{
		get
		{
			return m_CreateBackgroundSnapshotViewContext;
		}
		set
		{
			m_CreateBackgroundSnapshotViewContext = value;
		}
	}

	public void Set(ref IOSCredentialsSystemAuthCredentialsOptions other)
	{
		m_ApiVersion = 2;
		PresentationContextProviding = other.PresentationContextProviding;
		m_CreateBackgroundSnapshotView = ((other.CreateBackgroundSnapshotView != null) ? Marshal.GetFunctionPointerForDelegate(CreateBackgroundSnapshotView) : IntPtr.Zero);
		CreateBackgroundSnapshotViewContext = other.CreateBackgroundSnapshotViewContext;
	}

	public void Set(ref IOSCredentialsSystemAuthCredentialsOptions? other)
	{
		if (other.HasValue)
		{
			m_ApiVersion = 2;
			PresentationContextProviding = other.Value.PresentationContextProviding;
			m_CreateBackgroundSnapshotView = ((other.Value.CreateBackgroundSnapshotView != null) ? Marshal.GetFunctionPointerForDelegate(CreateBackgroundSnapshotView) : IntPtr.Zero);
			CreateBackgroundSnapshotViewContext = other.Value.CreateBackgroundSnapshotViewContext;
		}
	}

	public void Dispose()
	{
		Helper.Dispose(ref m_PresentationContextProviding);
		Helper.Dispose(ref m_CreateBackgroundSnapshotView);
		Helper.Dispose(ref m_CreateBackgroundSnapshotViewContext);
	}

	public void Get(out IOSCredentialsSystemAuthCredentialsOptions output)
	{
		output = default(IOSCredentialsSystemAuthCredentialsOptions);
		output.Set(ref this);
	}
}
