using System;
using System.Runtime.InteropServices;

namespace Epic.OnlineServices.P2P;

[StructLayout(LayoutKind.Sequential, Pack = 8)]
internal struct ReceivePacketOptionsInternal : IDisposable
{
	private int m_ApiVersion;

	private IntPtr m_LocalUserId;

	private uint m_MaxDataSizeBytes;

	public IntPtr m_RequestedChannel;

	public ReceivePacketOptionsInternal(ref ReceivePacketOptions other)
	{
		m_ApiVersion = 2;
		m_RequestedChannel = IntPtr.Zero;
		if (other.RequestedChannel.HasValue)
		{
			m_RequestedChannel = Helper.AddPinnedBuffer(other.m_RequestedChannel);
		}
		m_LocalUserId = other.LocalUserId.InnerHandle;
		m_MaxDataSizeBytes = other.MaxDataSizeBytes;
	}

	public void Dispose()
	{
		Helper.Dispose(ref m_LocalUserId);
		Helper.Dispose(ref m_RequestedChannel);
	}
}
