using System;
using Epic.OnlineServices.Achievements;
using Epic.OnlineServices.AntiCheatClient;
using Epic.OnlineServices.AntiCheatServer;
using Epic.OnlineServices.Auth;
using Epic.OnlineServices.Connect;
using Epic.OnlineServices.CustomInvites;
using Epic.OnlineServices.Ecom;
using Epic.OnlineServices.Friends;
using Epic.OnlineServices.IntegratedPlatform;
using Epic.OnlineServices.KWS;
using Epic.OnlineServices.Leaderboards;
using Epic.OnlineServices.Lobby;
using Epic.OnlineServices.Metrics;
using Epic.OnlineServices.Mods;
using Epic.OnlineServices.P2P;
using Epic.OnlineServices.PlayerDataStorage;
using Epic.OnlineServices.Presence;
using Epic.OnlineServices.ProgressionSnapshot;
using Epic.OnlineServices.RTC;
using Epic.OnlineServices.RTCAdmin;
using Epic.OnlineServices.Reports;
using Epic.OnlineServices.Sanctions;
using Epic.OnlineServices.Sessions;
using Epic.OnlineServices.Stats;
using Epic.OnlineServices.TitleStorage;
using Epic.OnlineServices.UI;
using Epic.OnlineServices.UserInfo;

namespace Epic.OnlineServices.Platform;

public sealed class PlatformInterface : Handle
{
	public const int AndroidInitializeoptionssysteminitializeoptionsApiLatest = 2;

	public static readonly Utf8String CheckforlauncherandrestartEnvVar = "EOS_LAUNCHED_BY_EPIC";

	public const int ClientcredentialsClientidMaxLength = 64;

	public const int ClientcredentialsClientsecretMaxLength = 64;

	public const int CountrycodeMaxBufferLen = 5;

	public const int CountrycodeMaxLength = 4;

	public const int GetdesktopcrossplaystatusApiLatest = 1;

	public const int InitializeApiLatest = 4;

	public const int InitializeThreadaffinityApiLatest = 3;

	public const int InitializeoptionsProductnameMaxLength = 64;

	public const int InitializeoptionsProductversionMaxLength = 64;

	public const int LocalecodeMaxBufferLen = 10;

	public const int LocalecodeMaxLength = 9;

	public const int OptionsApiLatest = 14;

	public const int OptionsDeploymentidMaxLength = 64;

	public const int OptionsEncryptionkeyLength = 64;

	public const int OptionsProductidMaxLength = 64;

	public const int OptionsSandboxidMaxLength = 64;

	public const int RtcoptionsApiLatest = 2;

	public const int WindowsRtcoptionsplatformspecificoptionsApiLatest = 1;

	public static Result Initialize(ref AndroidInitializeOptions options)
	{
		AndroidInitializeOptionsInternal options2 = default(AndroidInitializeOptionsInternal);
		options2.Set(ref options);
		Result result = AndroidBindings.EOS_Initialize(ref options2);
		Helper.Dispose(ref options2);
		return result;
	}

	public PlatformInterface()
	{
	}

	public PlatformInterface(IntPtr innerHandle)
		: base(innerHandle)
	{
	}

	public Result CheckForLauncherAndRestart()
	{
		return Bindings.EOS_Platform_CheckForLauncherAndRestart(base.InnerHandle);
	}

	public static PlatformInterface Create(ref Options options)
	{
		OptionsInternal options2 = default(OptionsInternal);
		options2.Set(ref options);
		IntPtr from = Bindings.EOS_Platform_Create(ref options2);
		Helper.Dispose(ref options2);
		Helper.Get(from, out PlatformInterface to);
		return to;
	}

	public AchievementsInterface GetAchievementsInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetAchievementsInterface(base.InnerHandle);
		Helper.Get(from, out AchievementsInterface to);
		return to;
	}

	public Result GetActiveCountryCode(EpicAccountId localUserId, out Utf8String outBuffer)
	{
		IntPtr to = IntPtr.Zero;
		Helper.Set(localUserId, ref to);
		int inOutBufferLength = 5;
		IntPtr value = Helper.AddAllocation(inOutBufferLength);
		Result result = Bindings.EOS_Platform_GetActiveCountryCode(base.InnerHandle, to, value, ref inOutBufferLength);
		Helper.Get(value, out outBuffer);
		Helper.Dispose(ref value);
		return result;
	}

	public Result GetActiveLocaleCode(EpicAccountId localUserId, out Utf8String outBuffer)
	{
		IntPtr to = IntPtr.Zero;
		Helper.Set(localUserId, ref to);
		int inOutBufferLength = 10;
		IntPtr value = Helper.AddAllocation(inOutBufferLength);
		Result result = Bindings.EOS_Platform_GetActiveLocaleCode(base.InnerHandle, to, value, ref inOutBufferLength);
		Helper.Get(value, out outBuffer);
		Helper.Dispose(ref value);
		return result;
	}

	public AntiCheatClientInterface GetAntiCheatClientInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetAntiCheatClientInterface(base.InnerHandle);
		Helper.Get(from, out AntiCheatClientInterface to);
		return to;
	}

	public AntiCheatServerInterface GetAntiCheatServerInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetAntiCheatServerInterface(base.InnerHandle);
		Helper.Get(from, out AntiCheatServerInterface to);
		return to;
	}

	public ApplicationStatus GetApplicationStatus()
	{
		return Bindings.EOS_Platform_GetApplicationStatus(base.InnerHandle);
	}

	public AuthInterface GetAuthInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetAuthInterface(base.InnerHandle);
		Helper.Get(from, out AuthInterface to);
		return to;
	}

	public ConnectInterface GetConnectInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetConnectInterface(base.InnerHandle);
		Helper.Get(from, out ConnectInterface to);
		return to;
	}

	public CustomInvitesInterface GetCustomInvitesInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetCustomInvitesInterface(base.InnerHandle);
		Helper.Get(from, out CustomInvitesInterface to);
		return to;
	}

	public Result GetDesktopCrossplayStatus(ref GetDesktopCrossplayStatusOptions options, out DesktopCrossplayStatusInfo outDesktopCrossplayStatusInfo)
	{
		GetDesktopCrossplayStatusOptionsInternal options2 = default(GetDesktopCrossplayStatusOptionsInternal);
		options2.Set(ref options);
		DesktopCrossplayStatusInfoInternal outDesktopCrossplayStatusInfo2 = Helper.GetDefault<DesktopCrossplayStatusInfoInternal>();
		Result result = Bindings.EOS_Platform_GetDesktopCrossplayStatus(base.InnerHandle, ref options2, ref outDesktopCrossplayStatusInfo2);
		Helper.Dispose(ref options2);
		Helper.Get<DesktopCrossplayStatusInfoInternal, DesktopCrossplayStatusInfo>(ref outDesktopCrossplayStatusInfo2, out outDesktopCrossplayStatusInfo);
		return result;
	}

	public EcomInterface GetEcomInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetEcomInterface(base.InnerHandle);
		Helper.Get(from, out EcomInterface to);
		return to;
	}

	public FriendsInterface GetFriendsInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetFriendsInterface(base.InnerHandle);
		Helper.Get(from, out FriendsInterface to);
		return to;
	}

	public IntegratedPlatformInterface GetIntegratedPlatformInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetIntegratedPlatformInterface(base.InnerHandle);
		Helper.Get(from, out IntegratedPlatformInterface to);
		return to;
	}

	public KWSInterface GetKWSInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetKWSInterface(base.InnerHandle);
		Helper.Get(from, out KWSInterface to);
		return to;
	}

	public LeaderboardsInterface GetLeaderboardsInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetLeaderboardsInterface(base.InnerHandle);
		Helper.Get(from, out LeaderboardsInterface to);
		return to;
	}

	public LobbyInterface GetLobbyInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetLobbyInterface(base.InnerHandle);
		Helper.Get(from, out LobbyInterface to);
		return to;
	}

	public MetricsInterface GetMetricsInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetMetricsInterface(base.InnerHandle);
		Helper.Get(from, out MetricsInterface to);
		return to;
	}

	public ModsInterface GetModsInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetModsInterface(base.InnerHandle);
		Helper.Get(from, out ModsInterface to);
		return to;
	}

	public NetworkStatus GetNetworkStatus()
	{
		return Bindings.EOS_Platform_GetNetworkStatus(base.InnerHandle);
	}

	public Result GetOverrideCountryCode(out Utf8String outBuffer)
	{
		int inOutBufferLength = 5;
		IntPtr value = Helper.AddAllocation(inOutBufferLength);
		Result result = Bindings.EOS_Platform_GetOverrideCountryCode(base.InnerHandle, value, ref inOutBufferLength);
		Helper.Get(value, out outBuffer);
		Helper.Dispose(ref value);
		return result;
	}

	public Result GetOverrideLocaleCode(out Utf8String outBuffer)
	{
		int inOutBufferLength = 10;
		IntPtr value = Helper.AddAllocation(inOutBufferLength);
		Result result = Bindings.EOS_Platform_GetOverrideLocaleCode(base.InnerHandle, value, ref inOutBufferLength);
		Helper.Get(value, out outBuffer);
		Helper.Dispose(ref value);
		return result;
	}

	public P2PInterface GetP2PInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetP2PInterface(base.InnerHandle);
		Helper.Get(from, out P2PInterface to);
		return to;
	}

	public PlayerDataStorageInterface GetPlayerDataStorageInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetPlayerDataStorageInterface(base.InnerHandle);
		Helper.Get(from, out PlayerDataStorageInterface to);
		return to;
	}

	public PresenceInterface GetPresenceInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetPresenceInterface(base.InnerHandle);
		Helper.Get(from, out PresenceInterface to);
		return to;
	}

	public ProgressionSnapshotInterface GetProgressionSnapshotInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetProgressionSnapshotInterface(base.InnerHandle);
		Helper.Get(from, out ProgressionSnapshotInterface to);
		return to;
	}

	public RTCAdminInterface GetRTCAdminInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetRTCAdminInterface(base.InnerHandle);
		Helper.Get(from, out RTCAdminInterface to);
		return to;
	}

	public RTCInterface GetRTCInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetRTCInterface(base.InnerHandle);
		Helper.Get(from, out RTCInterface to);
		return to;
	}

	public ReportsInterface GetReportsInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetReportsInterface(base.InnerHandle);
		Helper.Get(from, out ReportsInterface to);
		return to;
	}

	public SanctionsInterface GetSanctionsInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetSanctionsInterface(base.InnerHandle);
		Helper.Get(from, out SanctionsInterface to);
		return to;
	}

	public SessionsInterface GetSessionsInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetSessionsInterface(base.InnerHandle);
		Helper.Get(from, out SessionsInterface to);
		return to;
	}

	public StatsInterface GetStatsInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetStatsInterface(base.InnerHandle);
		Helper.Get(from, out StatsInterface to);
		return to;
	}

	public TitleStorageInterface GetTitleStorageInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetTitleStorageInterface(base.InnerHandle);
		Helper.Get(from, out TitleStorageInterface to);
		return to;
	}

	public UIInterface GetUIInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetUIInterface(base.InnerHandle);
		Helper.Get(from, out UIInterface to);
		return to;
	}

	public UserInfoInterface GetUserInfoInterface()
	{
		IntPtr from = Bindings.EOS_Platform_GetUserInfoInterface(base.InnerHandle);
		Helper.Get(from, out UserInfoInterface to);
		return to;
	}

	public static Result Initialize(ref InitializeOptions options)
	{
		InitializeOptionsInternal options2 = default(InitializeOptionsInternal);
		options2.Set(ref options);
		Result result = Bindings.EOS_Initialize(ref options2);
		Helper.Dispose(ref options2);
		return result;
	}

	public void Release()
	{
		Bindings.EOS_Platform_Release(base.InnerHandle);
	}

	public Result SetApplicationStatus(ApplicationStatus newStatus)
	{
		return Bindings.EOS_Platform_SetApplicationStatus(base.InnerHandle, newStatus);
	}

	public Result SetNetworkStatus(NetworkStatus newStatus)
	{
		return Bindings.EOS_Platform_SetNetworkStatus(base.InnerHandle, newStatus);
	}

	public Result SetOverrideCountryCode(Utf8String newCountryCode)
	{
		IntPtr to = IntPtr.Zero;
		Helper.Set(newCountryCode, ref to);
		Result result = Bindings.EOS_Platform_SetOverrideCountryCode(base.InnerHandle, to);
		Helper.Dispose(ref to);
		return result;
	}

	public Result SetOverrideLocaleCode(Utf8String newLocaleCode)
	{
		IntPtr to = IntPtr.Zero;
		Helper.Set(newLocaleCode, ref to);
		Result result = Bindings.EOS_Platform_SetOverrideLocaleCode(base.InnerHandle, to);
		Helper.Dispose(ref to);
		return result;
	}

	public static Result Shutdown()
	{
		return Bindings.EOS_Shutdown();
	}

	public void Tick()
	{
		Bindings.EOS_Platform_Tick(base.InnerHandle);
	}

	public static Utf8String ToString(ApplicationStatus applicationStatus)
	{
		IntPtr from = Bindings.EOS_EApplicationStatus_ToString(applicationStatus);
		Helper.Get(from, out Utf8String to);
		return to;
	}

	public static Utf8String ToString(NetworkStatus networkStatus)
	{
		IntPtr from = Bindings.EOS_ENetworkStatus_ToString(networkStatus);
		Helper.Get(from, out Utf8String to);
		return to;
	}

	public static PlatformInterface Create(ref WindowsOptions options)
	{
		WindowsOptionsInternal options2 = default(WindowsOptionsInternal);
		options2.Set(ref options);
		IntPtr from = WindowsBindings.EOS_Platform_Create(ref options2);
		Helper.Dispose(ref options2);
		Helper.Get(from, out PlatformInterface to);
		return to;
	}
}
