using System;
using System.Runtime.InteropServices;

namespace Epic.OnlineServices.RTCData;

[StructLayout(LayoutKind.Sequential, Pack = 8)]
internal struct DataReceivedCallbackInfoInternal : ICallbackInfoInternal, IGettable<DataReceivedCallbackInfo>, ISettable<DataReceivedCallbackInfo>, IDisposable
{
	private IntPtr m_ClientData;

	private IntPtr m_LocalUserId;

	private IntPtr m_RoomName;

	private uint m_DataLengthBytes;

	private IntPtr m_Data;

	private IntPtr m_ParticipantId;

	public object ClientData
	{
		get
		{
			Helper.Get(m_ClientData, out object to);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_ClientData);
		}
	}

	public IntPtr ClientDataAddress => m_ClientData;

	public ProductUserId LocalUserId
	{
		get
		{
			Helper.Get(m_LocalUserId, out ProductUserId to);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_LocalUserId);
		}
	}

	public Utf8String RoomName
	{
		get
		{
			Helper.Get(m_RoomName, out Utf8String to);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_RoomName);
		}
	}

	public ArraySegment<byte> Data
	{
		get
		{
			Helper.Get(m_Data, out var to, m_DataLengthBytes);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_Data, out m_DataLengthBytes);
		}
	}

	public ProductUserId ParticipantId
	{
		get
		{
			Helper.Get(m_ParticipantId, out ProductUserId to);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_ParticipantId);
		}
	}

	public void Set(ref DataReceivedCallbackInfo other)
	{
		ClientData = other.ClientData;
		LocalUserId = other.LocalUserId;
		RoomName = other.RoomName;
		Data = other.Data;
		ParticipantId = other.ParticipantId;
	}

	public void Set(ref DataReceivedCallbackInfo? other)
	{
		if (other.HasValue)
		{
			ClientData = other.Value.ClientData;
			LocalUserId = other.Value.LocalUserId;
			RoomName = other.Value.RoomName;
			Data = other.Value.Data;
			ParticipantId = other.Value.ParticipantId;
		}
	}

	public void Dispose()
	{
		Helper.Dispose(ref m_ClientData);
		Helper.Dispose(ref m_LocalUserId);
		Helper.Dispose(ref m_RoomName);
		Helper.Dispose(ref m_Data);
		Helper.Dispose(ref m_ParticipantId);
	}

	public void Get(out DataReceivedCallbackInfo output)
	{
		output = default(DataReceivedCallbackInfo);
		output.Set(ref this);
	}
}
