using System;
using System.Runtime.InteropServices;

namespace Epic.OnlineServices.Sanctions;

[StructLayout(LayoutKind.Sequential, Pack = 8)]
internal struct CreatePlayerSanctionAppealOptionsInternal : ISettable<CreatePlayerSanctionAppealOptions>, IDisposable
{
	private int m_ApiVersion;

	private IntPtr m_LocalUserId;

	private SanctionAppealReason m_Reason;

	private IntPtr m_ReferenceId;

	public ProductUserId LocalUserId
	{
		set
		{
			Helper.Set(value, ref m_LocalUserId);
		}
	}

	public SanctionAppealReason Reason
	{
		set
		{
			m_Reason = value;
		}
	}

	public Utf8String ReferenceId
	{
		set
		{
			Helper.Set(value, ref m_ReferenceId);
		}
	}

	public void Set(ref CreatePlayerSanctionAppealOptions other)
	{
		m_ApiVersion = 1;
		LocalUserId = other.LocalUserId;
		Reason = other.Reason;
		ReferenceId = other.ReferenceId;
	}

	public void Set(ref CreatePlayerSanctionAppealOptions? other)
	{
		if (other.HasValue)
		{
			m_ApiVersion = 1;
			LocalUserId = other.Value.LocalUserId;
			Reason = other.Value.Reason;
			ReferenceId = other.Value.ReferenceId;
		}
	}

	public void Dispose()
	{
		Helper.Dispose(ref m_LocalUserId);
		Helper.Dispose(ref m_ReferenceId);
	}
}
