#version 330 core

#include "Reconstruction_inc.glsl"

//-------------------------------------------------------------------------------------------------------------------------
//                                  Shader Params
//-------------------------------------------------------------------------------------------------------------------------
uniform sampler2D uDepthTexture;
uniform mat4 uProjectionMatrix;
uniform float uInvFarClip;

//-------------------------------------------------------------------------------------------------------------------------
//                                  In
//-------------------------------------------------------------------------------------------------------------------------
in vec2 fragTexCoords;

//-------------------------------------------------------------------------------------------------------------------------
//                                  Out
//-------------------------------------------------------------------------------------------------------------------------
layout (location = 0) out float outDepth;

//-------------------------------------------------------------------------------------------------------------------------

void main(void)
{	
	// Get hardware Z value
    float depth = texture(uDepthTexture, fragTexCoords).r;

	// Put it back to View Space
	float depthVS = GetLinearDepthFromDepthHW(depth, uProjectionMatrix);

	// Write the linear Z in the Red channel
    outDepth = depthVS * uInvFarClip;
}
