#!/bin/bash
set -e

GREEN="\e[32m"
RED="\e[31m"
ENDCOLOR="\e[0m"

# this bit looks like malware. it's not. ANSI is a shitshow.
# see the ./tf_ascii_rainbow.raw file and cat it, that's
# the content here.

echo "[38;2;204;1;178m┌[39m[38;2;200;1;181m─[39m[38;2;197;1;185m─[39m[38;2;193;1;189m─[39m[38;2;189;1;193m─[39m[38;2;186;1;196m─[39m[38;2;182;1;200m─[39m[38;2;178;1;203m─[39m[38;2;174;2;207m─[39m[38;2;170;3;210m─[39m[38;2;166;3;213m─[39m[38;2;162;4;216m─[39m[38;2;158;6;219m─[39m[38;2;154;7;222m─[39m[38;2;150;8;225m─[39m[38;2;145;10;227m─[39m[38;2;141;11;230m─[39m[38;2;137;13;232m─[39m[38;2;133;15;235m─[39m[38;2;129;17;237m─[39m[38;2;124;19;239m─[39m[38;2;120;21;241m─[39m[38;2;116;24;243m─[39m[38;2;112;26;245m─[39m[38;2;107;29;246m─[39m[38;2;103;32;248m─[39m[38;2;99;34;249m─[39m[38;2;95;37;250m─[39m[38;2;91;40;251m─[39m[38;2;87;44;252m─[39m[38;2;83;47;253m─[39m[38;2;79;50;253m─[39m[38;2;75;53;254m─[39m[38;2;71;57;254m─[39m[38;2;68;61;254m─[39m[38;2;64;64;254m─[39m[38;2;60;68;254m─[39m[38;2;57;72;254m─[39m[38;2;53;75;254m─[39m[38;2;50;79;253m─[39m[38;2;46;83;253m─[39m[38;2;43;87;252m─[39m[38;2;40;91;251m─[39m[38;2;37;95;250m─[39m[38;2;34;100;249m─[39m[38;2;31;104;247m─[39m[38;2;29;108;246m─[39m[38;2;26;112;244m─[39m[38;2;24;116;243m─[39m[38;2;21;120;241m─[39m[38;2;19;125;239m─[39m[38;2;17;129;237m─[39m[38;2;15;133;235m─[39m[38;2;13;137;232m─[39m[38;2;11;142;230m─[39m[38;2;10;146;227m─[39m[38;2;8;150;225m─[39m[38;2;7;154;222m─[39m[38;2;5;158;219m─[39m[38;2;4;162;216m─[39m[38;2;3;166;213m─[39m[38;2;3;170;210m─[39m[38;2;2;174;206m─[39m[38;2;1;178;203m─[39m[38;2;1;182;199m─[39m[38;2;1;186;196m─[39m[38;2;1;190;192m─[39m[38;2;1;193;189m─[39m[38;2;1;197;185m─[39m[38;2;1;200;181m─[39m[38;2;1;204;177m─[39m[38;2;2;207;173m─[39m[38;2;3;210;169m─[39m[38;2;4;214;165m─[39m[38;2;5;217;161m┐[39m[38;2;6;220;157m[39m"
echo "[38;2;193;1;189m│[39m[38;2;189;1;193m█[39m[38;2;186;1;196m█[39m[38;2;182;1;200m█[39m[38;2;178;1;203m█[39m[38;2;174;2;207m█[39m[38;2;170;3;210m█[39m[38;2;166;3;213m█[39m[38;2;162;4;216m█[39m[38;2;158;6;219m╗[39m[38;2;154;7;222m█[39m[38;2;150;8;225m█[39m[38;2;145;10;227m█[39m[38;2;141;11;230m█[39m[38;2;137;13;232m█[39m[38;2;133;15;235m█[39m[38;2;129;17;237m█[39m[38;2;124;19;239m╗[39m[38;2;120;21;241m [39m[38;2;116;24;243m█[39m[38;2;112;26;245m█[39m[38;2;107;29;246m█[39m[38;2;103;32;248m█[39m[38;2;99;34;249m█[39m[38;2;95;37;250m╗[39m[38;2;91;40;251m [39m[38;2;87;44;252m█[39m[38;2;83;47;253m█[39m[38;2;79;50;253m█[39m[38;2;75;53;254m╗[39m[38;2;71;57;254m [39m[38;2;68;61;254m [39m[38;2;64;64;254m [39m[38;2;60;68;254m█[39m[38;2;57;72;254m█[39m[38;2;53;75;254m█[39m[38;2;50;79;253m╗[39m[38;2;46;83;253m█[39m[38;2;43;87;252m█[39m[38;2;40;91;251m╗[39m[38;2;37;95;250m█[39m[38;2;34;100;249m█[39m[38;2;31;104;247m█[39m[38;2;29;108;246m█[39m[38;2;26;112;244m█[39m[38;2;24;116;243m█[39m[38;2;21;120;241m█[39m[38;2;19;125;239m╗[39m[38;2;17;129;237m█[39m[38;2;15;133;235m█[39m[38;2;13;137;232m█[39m[38;2;11;142;230m█[39m[38;2;10;146;227m█[39m[38;2;8;150;225m█[39m[38;2;7;154;222m╗[39m[38;2;5;158;219m [39m[38;2;4;162;216m [39m[38;2;3;166;213m█[39m[38;2;3;170;210m█[39m[38;2;2;174;206m█[39m[38;2;1;178;203m█[39m[38;2;1;182;199m█[39m[38;2;1;186;196m█[39m[38;2;1;190;192m╗[39m[38;2;1;193;189m [39m[38;2;1;197;185m [39m[38;2;1;200;181m█[39m[38;2;1;204;177m█[39m[38;2;2;207;173m█[39m[38;2;3;210;169m█[39m[38;2;4;214;165m█[39m[38;2;5;217;161m█[39m[38;2;6;220;157m╗[39m[38;2;7;222;153m [39m[38;2;8;225;149m│[39m[38;2;10;228;145m[39m"
echo "[38;2;182;1;200m│[39m[38;2;178;1;203m╚[39m[38;2;174;2;207m═[39m[38;2;170;3;210m═[39m[38;2;166;3;213m█[39m[38;2;162;4;216m█[39m[38;2;158;6;219m╔[39m[38;2;154;7;222m═[39m[38;2;150;8;225m═[39m[38;2;145;10;227m╝[39m[38;2;141;11;230m█[39m[38;2;137;13;232m█[39m[38;2;133;15;235m╔[39m[38;2;129;17;237m═[39m[38;2;124;19;239m═[39m[38;2;120;21;241m═[39m[38;2;116;24;243m═[39m[38;2;112;26;245m╝[39m[38;2;107;29;246m█[39m[38;2;103;32;248m█[39m[38;2;99;34;249m╔[39m[38;2;95;37;250m═[39m[38;2;91;40;251m═[39m[38;2;87;44;252m█[39m[38;2;83;47;253m█[39m[38;2;79;50;253m╗[39m[38;2;75;53;254m█[39m[38;2;71;57;254m█[39m[38;2;68;61;254m█[39m[38;2;64;64;254m█[39m[38;2;60;68;254m╗[39m[38;2;57;72;254m [39m[38;2;53;75;254m█[39m[38;2;50;79;253m█[39m[38;2;46;83;253m█[39m[38;2;43;87;252m█[39m[38;2;40;91;251m║[39m[38;2;37;95;250m█[39m[38;2;34;100;249m█[39m[38;2;31;104;247m║[39m[38;2;29;108;246m█[39m[38;2;26;112;244m█[39m[38;2;24;116;243m╔[39m[38;2;21;120;241m═[39m[38;2;19;125;239m═[39m[38;2;17;129;237m═[39m[38;2;15;133;235m═[39m[38;2;13;137;232m╝[39m[38;2;11;142;230m█[39m[38;2;10;146;227m█[39m[38;2;8;150;225m╔[39m[38;2;7;154;222m═[39m[38;2;5;158;219m═[39m[38;2;4;162;216m█[39m[38;2;3;166;213m█[39m[38;2;3;170;210m╗[39m[38;2;2;174;206m█[39m[38;2;1;178;203m█[39m[38;2;1;182;199m╔[39m[38;2;1;186;196m═[39m[38;2;1;190;192m═[39m[38;2;1;193;189m═[39m[38;2;1;197;185m█[39m[38;2;1;200;181m█[39m[38;2;1;204;177m╗[39m[38;2;2;207;173m█[39m[38;2;3;210;169m█[39m[38;2;4;214;165m╔[39m[38;2;5;217;161m═[39m[38;2;6;220;157m═[39m[38;2;7;222;153m═[39m[38;2;8;225;149m═[39m[38;2;10;228;145m╝[39m[38;2;12;230;141m [39m[38;2;13;233;136m│[39m[38;2;15;235;132m[39m"
echo "[38;2;170;3;210m│[39m[38;2;166;3;213m [39m[38;2;162;4;216m [39m[38;2;158;6;219m [39m[38;2;154;7;222m█[39m[38;2;150;8;225m█[39m[38;2;145;10;227m║[39m[38;2;141;11;230m [39m[38;2;137;13;232m [39m[38;2;133;15;235m [39m[38;2;129;17;237m█[39m[38;2;124;19;239m█[39m[38;2;120;21;241m█[39m[38;2;116;24;243m█[39m[38;2;112;26;245m█[39m[38;2;107;29;246m╗[39m[38;2;103;32;248m [39m[38;2;99;34;249m [39m[38;2;95;37;250m█[39m[38;2;91;40;251m█[39m[38;2;87;44;252m█[39m[38;2;83;47;253m█[39m[38;2;79;50;253m█[39m[38;2;75;53;254m█[39m[38;2;71;57;254m█[39m[38;2;68;61;254m║[39m[38;2;64;64;254m█[39m[38;2;60;68;254m█[39m[38;2;57;72;254m╔[39m[38;2;53;75;254m█[39m[38;2;50;79;253m█[39m[38;2;46;83;253m█[39m[38;2;43;87;252m█[39m[38;2;40;91;251m╔[39m[38;2;37;95;250m█[39m[38;2;34;100;249m█[39m[38;2;31;104;247m║[39m[38;2;29;108;246m█[39m[38;2;26;112;244m█[39m[38;2;24;116;243m║[39m[38;2;21;120;241m█[39m[38;2;19;125;239m█[39m[38;2;17;129;237m█[39m[38;2;15;133;235m█[39m[38;2;13;137;232m█[39m[38;2;11;142;230m╗[39m[38;2;10;146;227m [39m[38;2;8;150;225m [39m[38;2;7;154;222m█[39m[38;2;5;158;219m█[39m[38;2;4;162;216m█[39m[38;2;3;166;213m█[39m[38;2;3;170;210m█[39m[38;2;2;174;206m█[39m[38;2;1;178;203m╔[39m[38;2;1;182;199m╝[39m[38;2;1;186;196m█[39m[38;2;1;190;192m█[39m[38;2;1;193;189m║[39m[38;2;1;197;185m [39m[38;2;1;200;181m [39m[38;2;1;204;177m [39m[38;2;2;207;173m█[39m[38;2;3;210;169m█[39m[38;2;4;214;165m║[39m[38;2;5;217;161m█[39m[38;2;6;220;157m█[39m[38;2;7;222;153m║[39m[38;2;8;225;149m [39m[38;2;10;228;145m [39m[38;2;12;230;141m█[39m[38;2;13;233;136m█[39m[38;2;15;235;132m█[39m[38;2;17;237;128m╗[39m[38;2;20;239;124m│[39m[38;2;22;241;119m[39m"
echo "[38;2;158;6;219m│[39m[38;2;154;7;222m [39m[38;2;150;8;225m [39m[38;2;145;10;227m [39m[38;2;141;11;230m█[39m[38;2;137;13;232m█[39m[38;2;133;15;235m║[39m[38;2;129;17;237m [39m[38;2;124;19;239m [39m[38;2;120;21;241m [39m[38;2;116;24;243m█[39m[38;2;112;26;245m█[39m[38;2;107;29;246m╔[39m[38;2;103;32;248m═[39m[38;2;99;34;249m═[39m[38;2;95;37;250m╝[39m[38;2;91;40;251m [39m[38;2;87;44;252m [39m[38;2;83;47;253m█[39m[38;2;79;50;253m█[39m[38;2;75;53;254m╔[39m[38;2;71;57;254m═[39m[38;2;68;61;254m═[39m[38;2;64;64;254m█[39m[38;2;60;68;254m█[39m[38;2;57;72;254m║[39m[38;2;53;75;254m█[39m[38;2;50;79;253m█[39m[38;2;46;83;253m║[39m[38;2;43;87;252m╚[39m[38;2;40;91;251m█[39m[38;2;37;95;250m█[39m[38;2;34;100;249m╔[39m[38;2;31;104;247m╝[39m[38;2;29;108;246m█[39m[38;2;26;112;244m█[39m[38;2;24;116;243m║[39m[38;2;21;120;241m╚[39m[38;2;19;125;239m═[39m[38;2;17;129;237m╝[39m[38;2;15;133;235m█[39m[38;2;13;137;232m█[39m[38;2;11;142;230m╔[39m[38;2;10;146;227m═[39m[38;2;8;150;225m═[39m[38;2;7;154;222m╝[39m[38;2;5;158;219m [39m[38;2;4;162;216m [39m[38;2;3;166;213m█[39m[38;2;3;170;210m█[39m[38;2;2;174;206m╔[39m[38;2;1;178;203m═[39m[38;2;1;182;199m═[39m[38;2;1;186;196m█[39m[38;2;1;190;192m█[39m[38;2;1;193;189m╗[39m[38;2;1;197;185m█[39m[38;2;1;200;181m█[39m[38;2;1;204;177m║[39m[38;2;2;207;173m [39m[38;2;3;210;169m [39m[38;2;4;214;165m [39m[38;2;5;217;161m█[39m[38;2;6;220;157m█[39m[38;2;7;222;153m║[39m[38;2;8;225;149m█[39m[38;2;10;228;145m█[39m[38;2;12;230;141m║[39m[38;2;13;233;136m [39m[38;2;15;235;132m [39m[38;2;17;237;128m [39m[38;2;20;239;124m█[39m[38;2;22;241;119m█[39m[38;2;24;243;115m║[39m[38;2;27;245;111m│[39m[38;2;29;246;107m[39m"
echo "[38;2;145;10;227m│[39m[38;2;141;11;230m [39m[38;2;137;13;232m [39m[38;2;133;15;235m [39m[38;2;129;17;237m█[39m[38;2;124;19;239m█[39m[38;2;120;21;241m║[39m[38;2;116;24;243m [39m[38;2;112;26;245m [39m[38;2;107;29;246m [39m[38;2;103;32;248m█[39m[38;2;99;34;249m█[39m[38;2;95;37;250m█[39m[38;2;91;40;251m█[39m[38;2;87;44;252m█[39m[38;2;83;47;253m█[39m[38;2;79;50;253m█[39m[38;2;75;53;254m╗[39m[38;2;71;57;254m█[39m[38;2;68;61;254m█[39m[38;2;64;64;254m║[39m[38;2;60;68;254m [39m[38;2;57;72;254m [39m[38;2;53;75;254m█[39m[38;2;50;79;253m█[39m[38;2;46;83;253m║[39m[38;2;43;87;252m█[39m[38;2;40;91;251m█[39m[38;2;37;95;250m║[39m[38;2;34;100;249m [39m[38;2;31;104;247m╚[39m[38;2;29;108;246m═[39m[38;2;26;112;244m╝[39m[38;2;24;116;243m [39m[38;2;21;120;241m█[39m[38;2;19;125;239m█[39m[38;2;17;129;237m║[39m[38;2;15;133;235m█[39m[38;2;13;137;232m█[39m[38;2;11;142;230m╗[39m[38;2;10;146;227m█[39m[38;2;8;150;225m█[39m[38;2;7;154;222m║[39m[38;2;5;158;219m [39m[38;2;4;162;216m [39m[38;2;3;166;213m [39m[38;2;3;170;210m [39m[38;2;2;174;206m [39m[38;2;1;178;203m█[39m[38;2;1;182;199m█[39m[38;2;1;186;196m║[39m[38;2;1;190;192m [39m[38;2;1;193;189m [39m[38;2;1;197;185m█[39m[38;2;1;200;181m█[39m[38;2;1;204;177m║[39m[38;2;2;207;173m╚[39m[38;2;3;210;169m█[39m[38;2;4;214;165m█[39m[38;2;5;217;161m█[39m[38;2;6;220;157m█[39m[38;2;7;222;153m█[39m[38;2;8;225;149m█[39m[38;2;10;228;145m╔[39m[38;2;12;230;141m╝[39m[38;2;13;233;136m╚[39m[38;2;15;235;132m█[39m[38;2;17;237;128m█[39m[38;2;20;239;124m█[39m[38;2;22;241;119m█[39m[38;2;24;243;115m█[39m[38;2;27;245;111m█[39m[38;2;29;246;107m╔[39m[38;2;32;248;103m╝[39m[38;2;35;249;98m│[39m[38;2;38;250;94m([39m[38;2;41;251;90ml[39m[38;2;44;252;86m)[39m[38;2;47;253;82m_[39m[38;2;51;253;78m_[39m[38;2;54;254;74m_[39m[38;2;58;254;71m([39m[38;2;61;254;67ml[39m[38;2;65;254;63m)[39m[38;2;68;254;60m[39m"
echo "[38;2;133;15;235m│[39m[38;2;129;17;237m [39m[38;2;124;19;239m [39m[38;2;120;21;241m [39m[38;2;116;24;243m╚[39m[38;2;112;26;245m═[39m[38;2;107;29;246m╝[39m[38;2;103;32;248m [39m[38;2;99;34;249m [39m[38;2;95;37;250m [39m[38;2;91;40;251m╚[39m[38;2;87;44;252m═[39m[38;2;83;47;253m═[39m[38;2;79;50;253m═[39m[38;2;75;53;254m═[39m[38;2;71;57;254m═[39m[38;2;68;61;254m═[39m[38;2;64;64;254m╝[39m[38;2;60;68;254m╚[39m[38;2;57;72;254m═[39m[38;2;53;75;254m╝[39m[38;2;50;79;253m [39m[38;2;46;83;253m [39m[38;2;43;87;252m╚[39m[38;2;40;91;251m═[39m[38;2;37;95;250m╝[39m[38;2;34;100;249m╚[39m[38;2;31;104;247m═[39m[38;2;29;108;246m╝[39m[38;2;26;112;244m [39m[38;2;24;116;243m [39m[38;2;21;120;241m [39m[38;2;19;125;239m [39m[38;2;17;129;237m [39m[38;2;15;133;235m╚[39m[38;2;13;137;232m═[39m[38;2;11;142;230m╝[39m[38;2;10;146;227m╚[39m[38;2;8;150;225m═[39m[38;2;7;154;222m╝[39m[38;2;5;158;219m╚[39m[38;2;4;162;216m═[39m[38;2;3;166;213m╝[39m[38;2;3;170;210m [39m[38;2;2;174;206m [39m[38;2;1;178;203m [39m[38;2;1;182;199m [39m[38;2;1;186;196m [39m[38;2;1;190;192m╚[39m[38;2;1;193;189m═[39m[38;2;1;197;185m╝[39m[38;2;1;200;181m [39m[38;2;1;204;177m [39m[38;2;2;207;173m╚[39m[38;2;3;210;169m═[39m[38;2;4;214;165m╝[39m[38;2;5;217;161m [39m[38;2;6;220;157m╚[39m[38;2;7;222;153m═[39m[38;2;8;225;149m═[39m[38;2;10;228;145m═[39m[38;2;12;230;141m═[39m[38;2;13;233;136m═[39m[38;2;15;235;132m╝[39m[38;2;17;237;128m [39m[38;2;20;239;124m [39m[38;2;22;241;119m╚[39m[38;2;24;243;115m═[39m[38;2;27;245;111m═[39m[38;2;29;246;107m═[39m[38;2;32;248;103m═[39m[38;2;35;249;98m═[39m[38;2;38;250;94m╝[39m[38;2;41;251;90m [39m[38;2;44;252;86m│[39m[38;2;47;253;82m/[39m[38;2;51;253;78m_[39m[38;2;54;254;74m_[39m[38;2;58;254;71m_[39m[38;2;61;254;67m_[39m[38;2;65;254;63m_[39m[38;2;68;254;60m_[39m[38;2;72;254;56m_[39m[38;2;76;254;53m\[39m[38;2;80;253;49m[39m"
echo "[38;2;120;21;241m└[39m[38;2;116;24;243m─[39m[38;2;112;26;245m─[39m[38;2;107;29;246m─[39m[38;2;103;32;248m─[39m[38;2;99;34;249m─[39m[38;2;95;37;250m─[39m[38;2;91;40;251m─[39m[38;2;87;44;252m─[39m[38;2;83;47;253m─[39m[38;2;79;50;253m─[39m[38;2;75;53;254m─[39m[38;2;71;57;254m─[39m[38;2;68;61;254m─[39m[38;2;64;64;254m─[39m[38;2;60;68;254m─[39m[38;2;57;72;254m─[39m[38;2;53;75;254m─[39m[38;2;50;79;253m─[39m[38;2;46;83;253m─[39m[38;2;43;87;252m─[39m[38;2;40;91;251m─[39m[38;2;37;95;250m─[39m[38;2;34;100;249m─[39m[38;2;31;104;247m─[39m[38;2;29;108;246m─[39m[38;2;26;112;244m─[39m[38;2;24;116;243m─[39m[38;2;21;120;241m─[39m[38;2;19;125;239m─[39m[38;2;17;129;237m─[39m[38;2;15;133;235m─[39m[38;2;13;137;232m─[39m[38;2;11;142;230m─[39m[38;2;10;146;227m─[39m[38;2;8;150;225m─[39m[38;2;7;154;222m─[39m[38;2;5;158;219m─[39m[38;2;4;162;216m─[39m[38;2;3;166;213m─[39m[38;2;3;170;210m─[39m[38;2;2;174;206m─[39m[38;2;1;178;203m─[39m[38;2;1;182;199m─[39m[38;2;1;186;196m─[39m[38;2;1;190;192m─[39m[38;2;1;193;189m─[39m[38;2;1;197;185m─[39m[38;2;1;200;181m─[39m[38;2;1;204;177m─[39m[38;2;2;207;173m─[39m[38;2;3;210;169m─[39m[38;2;4;214;165m─[39m[38;2;5;217;161m─[39m[38;2;6;220;157m─[39m[38;2;7;222;153m─[39m[38;2;8;225;149m─[39m[38;2;10;228;145m─[39m[38;2;12;230;141m─[39m[38;2;13;233;136m─[39m[38;2;15;235;132m─[39m[38;2;17;237;128m─[39m[38;2;20;239;124m─[39m[38;2;22;241;119m─[39m[38;2;24;243;115m─[39m[38;2;27;245;111m─[39m[38;2;29;246;107m─[39m[38;2;32;248;103m─[39m[38;2;35;249;98m─[39m[38;2;38;250;94m─[39m[38;2;41;251;90m─[39m[38;2;44;252;86m─[39m[38;2;47;253;82m─[39m[38;2;51;253;78m─[39m[38;2;54;254;74m┘[39m[38;2;58;254;71m\[39m[38;2;61;254;67m_[39m[38;2;65;254;63m_[39m[38;2;68;254;60m_[39m[38;2;72;254;56m_[39m[38;2;76;254;53m_[39m[38;2;80;253;49m_[39m[38;2;84;253;46m_[39m[38;2;88;252;43m/[39m[38;2;92;251;40m[39m"

echo -e "$GREEN                 [Core Services] - AD Enrollment Script$ENDCOLOR"

if [ "$EUID" -ne 0 ]
  then echo -e "$RED[!] This script requires root. Please run \`sudo $0\` instead.$ENDCOLOR"
  exit
fi

if [ $# -lt 3 ]
  then
    echo -e "$RED[!] Usage: $0 <dns_ip> <ad_domain> <enrollment_user>$ENDCOLOR"
    exit
fi

if [[ "$2" != "team.frog" ]]; then
    echo -n -e "${RED}[!] This script was only designed to join the team!Frog AD. Are you sure you want to continue? [y/N] $ENDCOLOR"
    read -r response
    response=${response,,}

    if [[ ! "$response" =~ ^(yes|y)$ ]]; then
        echo -e "$RED[!] Refusing to continue! (user says nay)$ENDCOLOR" >&2
        exit 1
    fi
fi

echo -e "$GREEN[*] Deploying!$ENDCOLOR"

DNS=$1
AD_DOMAIN=$2
ENROLLMENT_USER=$3

echo -e "$GREEN[*] Setting DNS server to: \"$DNS\"$ENDCOLOR"
nmcli con mod 'enp2s0' ipv4.dns $DNS
nmcli con mod "enp2s0" ipv4.ignore-auto-dns yes

echo -e "$GREEN[*] Restarting NetworkManager to apply the changes..$ENDCOLOR"
systemctl restart NetworkManager

echo -e "$GREEN[*] Installing required packages..$ENDCOLOR"

LOG_FILE=tf_ad_enroll.log
if { dnf -y update && dnf -y install realmd oddjob oddjob-mkhomedir sssd adcli krb5-workstation samba-winbind samba-winbind-clients samba-common-tools sudo policycoreutils-python-utils; } > "$LOG_FILE" 2>&1; then
    echo -e "$GREEN[*] Installed!$ENDCOLOR"
else
    EXIT_CODE=$?
    
    echo -e "$RED[!] Failed to install required packages. (Code: $EXIT_CODE)." >&2
    echo -e "[!] See $LOG_FILE for DNF logs.$ENDCOLOR" >&2
    
    exit $EXIT_CODE
fi

echo -e "$GREEN[*] Joining domain \"$AD_DOMAIN\" with user \"$ENROLLMENT_USER\"$ENDCOLOR"
realm join $AD_DOMAIN -U $ENROLLMENT_USER

echo -e "$GREEN[*] Copying default configurations for: SSSD, OpenSSH, Sudo.$ENDCOLOR"
cat <<EOF > /etc/sssd/sssd.conf
[sssd]
domains = $AD_DOMAIN
config_file_version = 2
services = nss, pam, ssh

[domain/$AD_DOMAIN]
ldap_user_ssh_public_key = sshPublicKey
default_shell = /bin/bash
krb5_store_password_if_offline = True
cache_credentials = True
krb5_realm = $AD_DOMAIN
realmd_tags = manages-system joined-with-samba
use_fully_qualified_names = False
override_homedir = /home/%u 
id_provider = ad
ad_domain = $AD_DOMAIN
ldap_id_mapping = True

access_provider = simple
simple_allow_groups = linux-access
EOF

chmod 600 /etc/sssd/sssd.conf

mkdir /etc/sudoers.d

cat <<EOF > /etc/sudoers.d/0-ad-sudoers
%Linux\ Admins ALL=(ALL:ALL) NOPASSWD:ALL
EOF

cat <<EOF > /etc/ssh/sshd_config
Port 22

LoginGraceTime 2m
PermitRootLogin yes
StrictModes yes
MaxAuthTries 6
MaxSessions 10

PubkeyAuthentication yes
AuthorizedKeysCommand /usr/bin/sss_ssh_authorizedkeys
AuthorizedKeysCommandUser nobody
PasswordAuthentication yes
PermitEmptyPasswords no

UsePAM yes

Subsystem	sftp	/usr/libexec/openssh/sftp-server
EOF

echo -e "$GREEN[*] Restarting services and finishing up..$ENDCOLOR"

# patch SSSD's service
cat <<EOF > /usr/lib/systemd/system/sssd.service
[Unit]
Description=System Security Services Daemon
# SSSD must be running before we permit user sessions
Before=systemd-user-sessions.service nss-user-lookup.target
Wants=nss-user-lookup.target
StartLimitIntervalSec=50s
StartLimitBurst=5
ConditionPathExists=|/etc/sssd/sssd.conf
ConditionDirectoryNotEmpty=|/etc/sssd/conf.d/
After=network-online.target

[Service]
Environment=DEBUG_LOGGER=--logger=files
EnvironmentFile=-/etc/sysconfig/sssd
# '-H' is used with /etc/sssd to support use case where /etc/sssd is a symlink.
# '-H' only allows following a command line argument itself, everything else encountered due to '-R' isn't followed.
ExecStartPre=+-/bin/chown -f -R -H root:sssd /etc/sssd
ExecStartPre=+-/bin/chmod -f -R g+r /etc/sssd
ExecStartPre=+-/bin/chmod -f g+x /etc/sssd
ExecStartPre=+-/bin/chmod -f g+x /etc/sssd/conf.d
ExecStartPre=+-/bin/chmod -f g+x /etc/sssd/pki
ExecStartPre=+-/bin/sh -c "/bin/chown -f -h sssd:sssd /var/lib/sss/db/*.ldb"
ExecStartPre=+-/bin/chown -f -R -h sssd:sssd /var/lib/sss/gpo_cache
ExecStartPre=+-/bin/sh -c "/bin/chown -f -h sssd:sssd /var/log/sssd/*.log"
ExecStart=/usr/sbin/sssd -i \${DEBUG_LOGGER}
Type=notify
NotifyAccess=main
Restart=on-abnormal
CapabilityBoundingSet= CAP_SETGID CAP_SETUID CAP_DAC_READ_SEARCH 
SecureBits=noroot noroot-locked
User=sssd
Group=sssd
# If service configured to be run under "root", uncomment "SupplementaryGroups"
#SupplementaryGroups=sssd

[Install]
WantedBy=multi-user.target
EOF

systemctl daemon-reload

LOG_FILE=tf_ad_enroll.log
if { systemctl restart sshd && systemctl restart sssd; } > "$LOG_FILE" 2>&1; then
    echo -e "$GREEN[*] Restarted services!$ENDCOLOR"
else
    EXIT_CODE=$?
    
    echo -e "$RED[!] Failed to restart services. (Code: $EXIT_CODE)." >&2
    echo -e "[!] See $LOG_FILE for logs.$ENDCOLOR" >&2
    
    exit $EXIT_CODE
fi

